<?php
// Lokasi file folder.txt
$file = 'folder.txt';

// Periksa apakah file folder.txt ada
if (!file_exists($file)) {
    die("File folder.txt tidak ditemukan!\n");
}

// Baca isi file folder.txt
$folders = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

// Periksa apakah file tidak kosong
if (empty($folders)) {
    die("File folder.txt kosong!\n");
}

foreach ($folders as $folderName) {
    // Hilangkan spasi di awal dan akhir
    $folderName = trim($folderName);

    // Lewati jika nama folder kosong
    if (empty($folderName)) {
        continue;
    }

    // Cek apakah folder sudah ada
    if (is_dir($folderName)) {
        echo "Folder '$folderName' sudah ada.\n";
        continue;
    }

    // Buat folder dengan izin 0755
    if (mkdir($folderName, 0755, true)) {
        echo "Folder '$folderName' berhasil dibuat.\n";
    } else {
        echo "Gagal membuat folder '$folderName'.\n";
    }
}
?>
