<?php
// Konfigurasi
$domain = "https://domain.com";
$maxUrlsPerSitemap = 2000;
$inputFile = "folder.txt";
$indexFile = "sitemap.xml";

// Baca isi folder.txt
$paths = file($inputFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$totalUrls = count($paths);
$totalSitemaps = ceil($totalUrls / $maxUrlsPerSitemap);

$sitemapFiles = [];

for ($i = 0; $i < $totalSitemaps; $i++) {
    $chunk = array_slice($paths, $i * $maxUrlsPerSitemap, $maxUrlsPerSitemap);
    $sitemapFile = "sitemap-" . ($i + 1) . ".xml";
    $sitemapFiles[] = $sitemapFile;

    $xml = new DOMDocument('1.0', 'UTF-8');
    $urlset = $xml->createElement("urlset");
    $urlset->setAttribute("xmlns", "http://www.sitemaps.org/schemas/sitemap/0.9");

    foreach ($chunk as $path) {
        $url = $xml->createElement("url");
        $loc = $xml->createElement("loc", htmlspecialchars(rtrim($domain, "/") . "/" . ltrim($path, "/")));
        $url->appendChild($loc);
        $urlset->appendChild($url);
    }

    $xml->appendChild($urlset);
    $xml->formatOutput = true;
    $xml->save($sitemapFile);
}

// Buat sitemap index
$xml = new DOMDocument('1.0', 'UTF-8');
$sitemapindex = $xml->createElement("sitemapindex");
$sitemapindex->setAttribute("xmlns", "http://www.sitemaps.org/schemas/sitemap/0.9");

foreach ($sitemapFiles as $file) {
    $sitemap = $xml->createElement("sitemap");
    $loc = $xml->createElement("loc", htmlspecialchars(rtrim($domain, "/") . "/" . $file));
    $lastmod = $xml->createElement("lastmod", date('c'));
    $sitemap->appendChild($loc);
    $sitemap->appendChild($lastmod);
    $sitemapindex->appendChild($sitemap);
}

$xml->appendChild($sitemapindex);
$xml->formatOutput = true;
$xml->save($indexFile);

echo "Sitemap berhasil dibuat. Total sitemap: $totalSitemaps\n";
?>
