<?php
// Lokasi file yang akan diupload
define('UPLOAD_FILE', 'phs.html');

// Lokasi file folder.txt
$folderFile = 'folder.txt';

// Periksa apakah file phs.html ada
if (!file_exists(UPLOAD_FILE)) {
    die("File phs.html tidak ditemukan!\n");
}

// Periksa apakah file folder.txt ada
if (!file_exists($folderFile)) {
    die("File folder.txt tidak ditemukan!\n");
}

// Baca isi file folder.txt
$folders = file($folderFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

// Periksa apakah file tidak kosong
if (empty($folders)) {
    die("File folder.txt kosong!\n");
}

// Baca isi file phs.html
$fileContent = file_get_contents(UPLOAD_FILE);

foreach ($folders as $folderName) {
    // Hilangkan spasi di awal dan akhir
    $folderName = trim($folderName);

    // Lewati jika nama folder kosong
    if (empty($folderName)) {
        continue;
    }

    // Periksa apakah folder ada
    if (!is_dir($folderName)) {
        echo "Folder '$folderName' tidak ditemukan. Lewati...\n";
        continue;
    }

    // Ganti teks "ADUTKIDUL" dengan nama folder
    $updatedContent = str_replace('$BRAND', $folderName, $fileContent);

    // Path untuk file index.html
    $destinationFile = rtrim($folderName, '/') . '/index.html';

    // Tulis file ke folder
    if (file_put_contents($destinationFile, $updatedContent)) {
        echo "File index.html berhasil diupload ke '$folderName'.\n";
    } else {
        echo "Gagal mengupload file ke '$folderName'.\n";
    }
}
?>
